package gov.va.med.domain.service.messaging;

import gov.va.med.domain.model.IPayload;

/**
 * Used to report an exception from the invoked process
 * without throwing it.  Has additional error/exception (cause) variable. 
 * <P>
 * The isOk() will return false indicating the process (transceive) 
 * failed.   This is different from whether the transcive succeeded 
 * but returned an error reposonse such as a NAK.  
 * <P>
 * Said another way: <BR>
 * Response.isOk is a non-business error wheras the NAK or other error response is 
 * within the conext of the business.  
 *
 * @author Joel Goldberg
 * @version $Id: ErrorResponse.java,v 1.2 2005/07/06 19:40:18 joel.goldberg Exp $
 * @since MHV 2.0 <br>July 2, 2005
 */
public class ErrorResponse extends Response
{ 
    private static final long serialVersionUID = 3617287947888964921L;
 
    private Exception cause;
     
    public ErrorResponse(MessageType messageType, IPayload payload) {
        super(messageType, payload);
        setOk(true);
    }
    public ErrorResponse(MessageType messageType, IPayload payload, Exception aCause) {
        super(messageType, payload);
        setCause(aCause);
    }
    
    public Exception getCause() {return cause; }
    
    public void setCause(Exception cause) {this.cause = cause;}
    public boolean isOk() {return false;}
    
}
